package cn.com.duiba.kjy.livecenter.api.remoteservice.cardLibrary;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.cardLibrary.CardCouponBatchDto;

import java.util.Date;
import java.util.List;

/**
 * @Author xujing
 * @Date 2021/3/3 10:05 上午
 */
@AdvancedFeignClient
public interface RemoteCardCouponBatchService {

    /**
     * 插入卡券批次,并创建库存
     * @param cardCouponBatchDto
     * @return
     */
    Long insertAndCreateStock(CardCouponBatchDto cardCouponBatchDto);


    /**
     * 查询卡券库批次
     * @param id
     * @return
     */
    CardCouponBatchDto findById(Long id);


    /**
     * 根据卡券库id查询所有卡券批次
     * @param cardLibraryId
     * @param status 0 有效 1失效 不传 查全部
     * @return
     */
    List<CardCouponBatchDto> listByCardLibraryIdAndStatus(Long cardLibraryId,Integer status);


    /**
     * 删除批次
     * 并且删除批次下的卡券
     * @param batchId
     * @return
     */
    Integer deleteById(Long batchId);

    /**
     * 查询批次重叠
     * @param cardLibraryId 卡券库id
     * @param startDay 批次开始时间
     * @param endDay 批次结束时间
     * @return
     */
    Boolean checkBatchOverlap(Long cardLibraryId, Date startDay,Date endDay);


}
