package cn.com.duiba.kjy.livecenter.api.remoteservice.liveplay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.aliyunlive.LiveAppDto;
import cn.com.duiba.kjy.livecenter.api.dto.aliyunlive.LivePlayPlatformDto;
import cn.com.duiba.kjy.livecenter.api.dto.aliyunlive.StreamUrlDto;

import java.util.List;

/**
 * @author dugq
 * @date 2020-09-23 14:51
 */
@AdvancedFeignClient
public interface RemoteKjjLivePlayService {

    /**
     * 根据直播ID查询直播流相关信息。
     * @param liveId 直播ID
     * @return 直播流的推流地址和平台
     */
    LivePlayPlatformDto findLivePlayDetailByLiveId(Long liveId);

    /**
     * 查询直播流的app列表。
     * 直播流都是挂载在app下的。不管是腾讯云还是阿里云都是如此设计
     */
    List<LiveAppDto> findLiveAppList();

    /**
     * 切换流挂载的app。
     * 可实现平台切换
     */
    void changeStreamPlatform(Long liveId, Long liveAppId);

    /**
     *根据直播ID获取正在使用的平台
     */
    Integer getPlatformByLiveId(Long liveId);

    /**
     * 获取流在指定app下的拉流列表
     * 10 分钟缓存。
     * @param liveId  直播ID
     * @param streamAppId aliyun_app 表ID   streamAppId == null 时查询正在使用的拉流列表。此时不走缓存。调用方可选择短暂缓存。
     * @return
     */
    List<StreamUrlDto> getPullUrlListWithCache(Long liveId, Long streamAppId);

    /**
     * 获取流正在使用的stream app id
     */
    Long getStreamAppId(Long streamId);
}
