package cn.com.duiba.kjy.livecenter.api.enums.conf;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 直播间配置key枚举
 *
 * @author 吴文哲
 * @date 2019-11-19 15:35
 **/
@Getter
public enum LiveExtEnum {

    /**
     * 直播间额外配置数据
     */
    INVITE_COUNT(1, "代理人指定中奖参与条件,邀请个数"),

    CUSTOMER_SERVICE(2, "客服信息"),

    SHARE_POSTERS(3, "分享海报"),

    LIVE_WITCH_NUM(4, "直播结束后观看人数"),

    LIVE_VEST_WITCH_NUM(5, "小马甲人数操作记录"),

    LIVE_BOOM_BACKGROUND_IMG(6, "直播间爆款背景图"),

    RETAIN_RED_SHOW_PRICE(7, "停留红包展示金额"),

    LIVE_HALF_PRICE_INTERVAL_CONFIG(8, "直播间半价抽奖间隔时间配置"),

    LIVE_HALF_PRICE_PRIZE_NUM(9, "直播间半价抽奖单轮抽取人数配置"),

    LIVE_APPOINTMENT_POP_IMG(10, "直播间预约弹窗图片"),

    LIVE_NEWER_SPECIFY_GOODS(11, "直播间新人专享商品"),

    LIVE_BOOM_GOODS_MARKET_TITLE(12, "直播间爆款商品营销标题"),

    LIVE_MARKET_ACTIVITY_TITLE(13, "直播间营销活动标题"),

    LIVE_MARKET_ACTIVITY_SUBTITLE(14, "直播间营销活动副标题"),

    LIVE_WELFARE_TITLE(15, "直播间福利标题"),

    LIVE_OTHER_WELFARE_IMG(16, "直播间其他福利图片"),

    LIVE_WELFARE_TYPE(17, "直播间福利项类型"),

    LIVE_PULL_URL(18, "直播间定制拉流地址"),

    LIVE_END_LIKED(19, "直播结束后点赞数"),

    LIVE_FLIP_WORD(20,"翻牌集字红包开关配置")

    ;

    /**
     * 键  长度限制64
     */
    Integer key;
    /**
     * 描述  长度限制1024
     */
    String desc;


    LiveExtEnum(Integer key, String desc) {
        this.key = key;
        this.desc = desc;
    }


    private static final Map<Integer, LiveExtEnum> ENUM_MAP = new HashMap<>();



    static{
        for(LiveExtEnum configEnum : values()){
            ENUM_MAP.put(configEnum.getKey(), configEnum);
        }
    }

    public static LiveExtEnum getByType(String key) {
        if (key == null) {
            return null;
        }
        return ENUM_MAP.get(key);
    }

    public static LiveExtEnum of(Integer key) {

        if (key == null) {
            return null;
        }
        return ENUM_MAP.get(key);
    }

    /**
     * 是否包含
     *
     * @param key
     * @return
     */
    public static boolean contains(String key) {
        if (StringUtils.isBlank(key)) {
            return false;
        }
        for (LiveExtEnum enumVal : LiveExtEnum.values()) {
            if (Objects.equals(enumVal.getKey(),key)) {
                return true;
            }
        }
        return false;
    }

}
