package cn.com.duiba.kjy.livecenter.api.remoteservice.task;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.task.TaskRecordDto;

import java.util.List;

/**
 * @Author xujing
 * @Date 2020/11/10 3:46 下午
 */
@AdvancedFeignClient
public interface RemoteTaskRecordService {

    /**
     * 根据直播间id 用户id 任务id数组 查询用户所有任务记录
     * @param liveId 直播间id
     * @param liveUserId 用户id
     * @param taskIds 任务id数组
     * @return
     */
    List<TaskRecordDto> listUserTaskRecords(Long liveId,Long liveUserId,List<Long> taskIds);


    /**
     * 完成任务
     * 返回主键
     * @param taskRecordDto
     * @return
     */
    Long completeTask(TaskRecordDto taskRecordDto);
}
