package cn.com.duiba.kjy.livecenter.api.dto.company;

import cn.com.duiba.kjy.livecenter.api.enums.company.AuthMpTypeEnum;
import cn.com.duiba.kjy.livecenter.api.enums.company.MpAuthStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播公司小程序
 * @author chengsiyi
 */
@Data
public class LiveCompanyMpDto implements Serializable {

    private static final long serialVersionUID = -3967210263232290047L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * base.tb_wx_authorize.id
     */
    private Long mpId;

    /**
     * 小程序类型:1-访客端，2-管理端
     *
     * @see AuthMpTypeEnum
     */
    private Integer mpType;

    /**
     * 微信端小程序ID
     */
    private String mpWechatId;

    /**
     * 授权状态
     *
     * @see MpAuthStatusEnum
     */
    private Integer authorizationStatus;
}

