package cn.com.duiba.kjy.livecenter.api.dto.smallshop.order;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: fss
 * @Date: 2021/9/7 15
 * @Description:
 */
@Data
public class OrderDetailDto implements Serializable {

    private static final long serialVersionUID = -7343979145136179407L;

    /**
     * 订单ID
     */
    @JSONField(name = "order_id")
    private String orderId;

    /**
     * 卖家备注
     */
    @JSONField(name = "seller_note")
    private String sellerNote;

    /**
     * 是否可以编辑称重退差，1:可以， 0或不返回表示不可以
     */
    @JSONField(name = "modify_weight_enable")
    private Integer modifyWeightEnable;

    /**
     * 订单来源,617:park普通商品订单
     */
    @JSONField(name = "order_source")
    private Integer orderSource;

    /**
     * 订单发货类型,4:快递发货;8:同城配送;16:到店自提
     */
    @JSONField(name = "delivery_type")
    private Integer deliveryType;

    /**
     * 发货调用源, open:开放平台
     */
    @JSONField(name = "deliver_source")
    private String deliverSource;

    /**
     * 卖家id
     */
    @JSONField(name = "seller_id")
    private String sellerId;

    /**
     * 分销商手机号
     */
    @JSONField(name = "f_phone")
    private String fPhone;

    /**
     * 储值卡抵扣-本金
     */
    @JSONField(name = "vcard_deduct_capital")
    private String vcardDeductCapital;

    /**
     * 储值卡抵扣-赠款
     */
    @JSONField(name = "vcard_deduct_gift")
    private String vcardDeductGift;

    /**
     * 礼品卡抵扣金额
     */
    @JSONField(name = "gcard_deduct_money")
    private String gcardDeductMoney;

    /**
     * 储值卡退款抵扣-本金
     */
    @JSONField(name = "vcard_refund_deduct_capital")
    private String vcardRefundDeductCapital;

    /**
     * 储值卡退款抵扣-赠款
     */
    @JSONField(name = "vcard_refund_deduct_gift")
    private String vcardRefundDeductGift;

    /**
     * 礼品卡退款抵扣金额
     */
    @JSONField(name = "gcard_refund_deduct_money")
    private String gcardRefundDeductMoney;

    /**
     * 订单是否可关闭; 0（表示不可关闭）; 1（表示货到付款订单，可关闭）
     */
    @JSONField(name = "is_close")
    private Integer isClose;

    /**
     * [此字段已经废弃]订单实际支付价格 （此字段用于记录订单修改后用户实际支付的价格，包含运费）
     */
    @JSONField(name = "real_income_price")
    private String realIncomePrice;

    /**
     * 退货单号
     */
    @JSONField(name = "return_code")
    private String returnCode;

    /**
     * 是否可以发货，0 否 1 是
     */
    @JSONField(name = "if_ship_enable")
    private Integer ifShipEnable;

    /**
     * 当前店铺角色 101:普通卖家  102:分销卖家 103:  供货商卖家  105:多级分销订单中的一级分销卖家  106:连锁店模式-总店  107:新供货：一级供货商  108:新供货：二级供货商
     */
    @JSONField(name = "role_type")
    private String roleType;

    /**
     * 状态
     */
    @JSONField(name = "status")
    private String status;

    /**
     * 状态描述
     */
    @JSONField(name = "status_desc")
    private String statusDesc;

    /**
     * 买家信息
     */
    @JSONField(name = "buyer_info")
    private BuyerInfoDto buyerInfoDto;

    /**
     * 优惠信息
     */
    @JSONField(name = "discount_list")
    private List<DiscountDto> discountList;

    /**
     * 跨境信息
     */
    @JSONField(name = "cross_info")
    private CrossInfoDto crossInfoDto;

    /**
     * 满赠信息
     */
    @JSONField(name = "full_gift_items")
    private List<FullGiftItemsDto> fullGiftItems;

    /**
     * 订单商品列表
     */
    @JSONField(name = "items")
    private List<OrderGoodsDetailDto> items;

}
