package cn.com.duiba.kjy.livecenter.api.param.qrcode;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * Created by hong
 * time 2021/11/25.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class QrcodeOperateParam {

    /**
     * 0 代表对应一个小程序码 1代表对应多个小程序码
     */
    private Integer mpType;

    /**
     * 直播id
     */
    private Long liveId;

    /**
     * 用户id
     */
    private Long visitorId;

    /**
     * 邀请渠道
     */
    private Integer inviteChannel;

    /**
     * 邀请子渠道
     */
    private String subChannel;

    /**
     * 日志父级分类(用于区分海报位置）
     */
    private Integer logCate;

    /**
     * 日志子级分类(用于区分海报位置）
     */
    private Integer logSubCate;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 海报二维码类型
     */
    private Integer qrcodeType;

    /**
     * 绑定参数
     */
    private List<String> scenes;
}
