package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2020/9/19 9:56 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveVisitorQrcodeService {
    /**
     * 根据liveId和visitorId查询小程序码
     *
     * @param liveId 直播id
     * @param visitorId 访客id
     * @return 小程序码
     */
    String getMpQrcodeUrl(Long liveId, Long visitorId);

    /**
     * 根据liveId和visitorId查询小程序码
     *
     * @param liveId 直播id
     * @param visitorId 访客id
     * @return 小程序码
     */
    List<String> getMpQrcodeUrlsCache(Long liveId, Long visitorId);

    /**
     * 获取访客小程序码 缓存10min
     *
     * @param liveId 直播id
     * @param visitorId 访客id
     * @return 小程序码
     */
    String getMpQrcodeUrlCache(Long liveId, Long visitorId);

    /**
     * 给访客绑定一个小程序码，并返回小程序码
     *
     * @param liveId 直播id
     * @param visitorId 访客id
     * @param scene 小程序码参数
     * @return 返回小程序码
     */
    String bindMpQrcode(Long liveId, Long visitorId, String scene);


    /**
     * 给访客绑定多个小程序码，并返回小程序码
     *
     * @param liveId 直播id
     * @param visitorId 访客id
     * @param scene 小程序码参数
     * @return 返回小程序码
     */
    List<String> bindMpQrcodes(Long liveId, Long visitorId, List<String> scene);

    /**
     * 绑定小程序码降级方案
     *
     * @param liveId 直播id
     * @param visitorId 访客id
     * @param scene 小程序码参数
     * @return 返回小程序码
     */
    String bindMpQrcodeDegrade(Long liveId, Long visitorId, String scene);

    /**
     * 绑定多个小程序码降级方案
     *
     * @param liveId    直播id
     * @param visitorId 访客id
     * @param scenes    小程序码参数
     * @return 返回小程序码
     */
    List<String> bindMpQrcodesDegrade(Long liveId, Long visitorId, List<String> scenes);

    /**
     * 更新用户二维码的邀请渠道
     *
     * @param mpType        0 代表对应一个小程序码 1代表对应多个小程序码
     * @param liveId        直播间数据
     * @param visitorId     直播用户ID
     * @param inviteChannel 邀请渠道
     * @param subChannel    邀请子渠道
     * @return 更新条数
     */
    Integer updateUserQrcodeChannel(Integer mpType, Long liveId, Long visitorId, Integer inviteChannel, String subChannel);

    /**
     * 根据liveId和visitorId查询小程序码
     *
     * @param liveId 直播id
     * @param visitorId 访客id
     * @return 小程序码
     */
    List<String> getMpQrcodeUrlsCacheV2(Long liveId, Long visitorId,Integer logCate,Integer logSubCate);

    /**
     * 绑定多个小程序码降级方案
     *
     * @param liveId    直播id
     * @param visitorId 访客id
     * @param scenes    小程序码参数
     * @return 返回小程序码
     */
    List<String> bindMpQrcodesDegradeV2(Long liveId, Long visitorId, List<String> scenes, Integer logCate, Integer logSubCate);

    /**
     * 给访客绑定多个小程序码，并返回小程序码
     *
     * @param liveId 直播id
     * @param visitorId 访客id
     * @param scene 小程序码参数
     * @return 返回小程序码
     */
    List<String> bindMpQrcodesV2(Long liveId, Long visitorId, List<String> scene, Integer logCate, Integer logSubCate);

    /**
     * 更新用户二维码的邀请渠道
     *
     * @param mpType        0 代表对应一个小程序码 1代表对应多个小程序码
     * @param liveId        直播间数据
     * @param visitorId     直播用户ID
     * @param inviteChannel 邀请渠道
     * @param subChannel    邀请子渠道
     * @return 更新条数
     */
    Integer updateUserQrcodeChannelV2(Integer mpType, Long liveId, Long visitorId, Integer inviteChannel, String subChannel, Integer logCate, Integer logSubCate);

}
