package cn.com.duiba.kjy.livecenter.api.dto.aliyunlive;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 阿里云app安全审核配置
 * @author kjj mybatis generator
 * 2020-03-27
 */
@Data
public class DetectionConfigDto implements Serializable {
    private static final long serialVersionUID = 15852889338246087L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *直播app的ID
     * not null default = null
     */
    private Long appId;

    /**
     *
     *直播app域名
     * max length = 255
     * not null default = null
     */
    private String domainName;

    /**
     *
     *检测间隔时间。5-3600.单位秒
     * not null default = 10
     */
    private Integer timeInterval;

    /**
     *
     *违规视频截屏保存地址 可根据阿里云预留的占位符自由组合
     * max length = 255
     * not null default = picture/detection/{AppName}/{StreamName}/{Sequence}
     */
    private String objectName;

    /**
     *
     *检测场景：porn,terrorism, ad, live, sface, logo多个逗号隔开
     * max length = 255
     * not null default = porn
     */
    private String scene;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}
