package cn.com.duiba.kjy.livecenter.api.dto.smallshop.order;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author: fss
 * @Date: 2021/9/7 15
 * @Description:
 */
@Data
public class CrossInfoDto implements Serializable {

    private static final long serialVersionUID = 7652094587939448508L;

    /**
     * 口岸编码，格式如NINGBO，如需查询全部支持口岸，参考接口跨境口岸列表
     */
    @JSONField(name = "cross_port_code")
    private String crossPortCode;

    /**
     * 跨境订单总货值/完税价格总和(商品完税价格*数量，不含税费)，不含完税运费，单位元
     */
    @JSONField(name = "cross_price")
    private String crossPrice;

    /**
     * 跨境订单完税运费(不含税费)，单位元
     */
    @JSONField(name = "cross_express_fee")
    private String crossExpressFee;

    /**
     * 跨境订单全部抵扣金额，单位元，其中抵扣金额=订单总货值+订单完税运费-订单实际支付金额
     */
    @JSONField(name = "cross_discount")
    private String crossDiscount;

    /**
     * 跨境订单实际支付金额，单位元
     */
    @JSONField(name = "cross_pay_price")
    private String crossPayPrice;

    /**
     * 跨境订单所用支付企业，在海关备案编号
     */
    @JSONField(name = "cross_merchant_customs_code")
    private String crossMerchantCustomsCode;

    /**
     * 跨境订单所用支付企业，在海关备案名称
     */
    @JSONField(name = "cross_merchant_customs_name")
    private String crossMerchantCustomsName;

    /**
     * 跨境订单，支付企业的支付单号
     */
    @JSONField(name = "pay_trade_no")
    private String payTradeNo;

}
