package cn.com.duiba.kjy.livecenter.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2021/11/27.
 */
@Getter
public enum QrcodeTypeEnum {

    DEFAULT(0, "default", "默认"),
    LOG_CATE(1, "logCate", "携带logCate的二维码"),
    LOG_CATE_ACTIVITY(2,"logCateActivity","携带logCate和activity的二维码"),
    LOG_CATE_CHANNEL(3,"logCateChannel","携带logCate和channel的二维码")
    ;


    private final Integer code;

    private final String  type;

    private final String  desc;

    QrcodeTypeEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static QrcodeTypeEnum getByCode(Integer code) {
        return Stream.of(QrcodeTypeEnum.values())
                     .filter(e -> e.getCode()
                                   .equals(code))
                     .findFirst()
                     .orElse(DEFAULT);
    }

    public static QrcodeTypeEnum getByType(String type) {
        return Stream.of(QrcodeTypeEnum.values())
                     .filter(e -> e.getType()
                                   .equals(type))
                     .findFirst()
                     .orElse(DEFAULT);
    }
}