package cn.com.duiba.kjy.livecenter.api.param.live;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 用户预约推送表
 * @author kjj mybatis generator 
 * @date 2020-08-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveUserAppointmentPushSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15964443497078054L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 预约ID（tb_live_user_appointment.id）
     */
    private Long appointmentId;

    /**
     * 预约业务ID（tb_live_user_appointment.biz_id）
     */
    private Long appointmentBizId;

    /**
     * 推送类型 1-开播提醒、2-活动开奖通知、3-活动领取通知
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.push.PushTypeEnum
     */
    private Integer pushType;
}