package cn.com.duiba.kjy.livecenter.api.param.user;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author chenhang
 * @date 2021/9/8 11:48 上午
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveUserQueryParam extends PageQuery {

    private static final long serialVersionUID = -1060436888018603752L;

    /**
     * 直播用户id
     */
    private Long id;

    /**
     * 微信昵称
     */
    private String nickname;

    /**
     * 授权手机号
     */
    private String authPhone;

    /**
     * 业务方类型
     */
    private Integer bizType;

    /**
     * 唯一ID，同一主体下唯一
     */
    private String unionId;

    /**
     * 用户性别，1=男性，2=女性，0=未知
     */
    private Integer gender;

}
