/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.livecenter.api.enums;

import java.util.stream.Stream;

public enum QrcodeTypeEnum {
    DEFAULT(0, "default", "\u9ed8\u8ba4"),
    LOG_CATE(1, "logCate", "\u643a\u5e26logCate\u7684\u4e8c\u7ef4\u7801"),
    LOG_CATE_ACTIVITY(2, "logCateActivity", "\u643a\u5e26logCate\u548cactivity\u7684\u4e8c\u7ef4\u7801"),
    LOG_CATE_CHANNEL(3, "logCateChannel", "\u643a\u5e26logCate\u548cchannel\u7684\u4e8c\u7ef4\u7801");

    private final Integer code;
    private final String type;
    private final String desc;

    private QrcodeTypeEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static QrcodeTypeEnum getByCode(Integer code) {
        return Stream.of(QrcodeTypeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(DEFAULT);
    }

    public static QrcodeTypeEnum getByType(String type) {
        return Stream.of(QrcodeTypeEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(DEFAULT);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }
}

