/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.livecenter.api.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedPacketRandomUtils {
    private static final Logger log = LoggerFactory.getLogger(RedPacketRandomUtils.class);
    private static Random random = new Random();

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        int redPacketAmount = 160;
        int redPacketNum = 3;
        int minAmount = 30;
        List<Integer> amountList = RedPacketRandomUtils.randomAlgorithm1(redPacketNum, redPacketAmount, minAmount);
        for (Integer amount2 : amountList) {
            System.out.println(amount2);
        }
        System.out.println("======");
        System.out.println(amountList.stream().mapToInt(amount -> amount).sum());
        double ave = (double)redPacketAmount * 1.0 / (double)redPacketNum;
        int max = (int)ave * 2;
        System.out.println(ave);
        System.out.println(max);
        System.out.println("===");
        System.out.println(System.currentTimeMillis() - start);
    }

    public static List<Integer> randomAlgorithm1(int redPacketNum, int redPacketAmount, int minAmount) {
        if (redPacketNum * minAmount > redPacketAmount) {
            return Collections.emptyList();
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        double ave = (double)redPacketAmount * 1.0 / (double)redPacketNum;
        int max = (int)ave * 2;
        double offset = 0.0;
        int originalAmount = redPacketAmount;
        int originalNum = redPacketNum;
        int totalAmount = 0;
        while (redPacketNum > 0) {
            if (redPacketNum == 1) {
                result.add(redPacketAmount);
                totalAmount += redPacketAmount;
                if (redPacketAmount <= max && redPacketAmount >= minAmount) break;
                log.error("randomAlgorithm1, amount error, redPacketNum={}, redPacketAmount={}, minAmount={}, amount={}", new Object[]{originalNum, originalAmount, minAmount, redPacketAmount});
                return Collections.emptyList();
            }
            int singleMin = offset < 0.0 ? (int)ave : minAmount;
            int singleMax = offset < 0.0 ? max : (int)ave;
            int amount = random.nextInt(singleMax);
            if (amount <= singleMin) {
                amount = singleMin;
            }
            if (RedPacketRandomUtils.overflow(redPacketAmount - amount, redPacketNum - 1, minAmount)) {
                amount = singleMin;
            }
            if (amount > max || amount < minAmount) {
                log.error("randomAlgorithm1, amount error, redPacketNum={}, redPacketAmount={}, minAmount={}, amount={}", new Object[]{originalNum, originalAmount, minAmount, amount});
                return Collections.emptyList();
            }
            result.add(amount);
            totalAmount += amount;
            offset = offset + (double)amount - ave;
            --redPacketNum;
            redPacketAmount -= amount;
        }
        if (totalAmount != originalAmount) {
            log.error("randomAlgorithm1, totalAmount != redPacketAmount, redPacketNum={}, redPacketAmount={}, minAmount={}, totalAmount={}", new Object[]{originalNum, originalAmount, minAmount, totalAmount});
            return Collections.emptyList();
        }
        return result;
    }

    private static boolean overflow(int surplusTotalAmount, int surplusTotalNum, int minAmount) {
        int needTotalAmount = minAmount * surplusTotalNum;
        return surplusTotalAmount < needTotalAmount;
    }
}

