package cn.com.duiba.kjy.livecenter.api.remoteservice.invitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.interaction.LiveSubscribeDto;
import cn.com.duiba.kjy.livecenter.api.param.interaction.LiveSubscribeSearchParam;

import java.util.List;
import java.util.Map;

/**
 * @author zhanghuifeng
 * date 2020/4/4-2:57 下午
 */
@AdvancedFeignClient
public interface RemoteLiveSubscribeService {

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LiveSubscribeSearchParam param);

    /**
     * 新增关注记录
     * @param liveUserId 关注用户ID
     * @param liveId 直播ID
     * @return 新增数量
     */
    int insert(Long liveUserId, Long liveId);

    /**
     * 获取用户是否关注直播间
     * @param liveUserId 用户ID
     * @param companyId 公司ID
     * @return 是否关注
     */
    boolean findSubscribeState(Long liveUserId, Long companyId);

    /**
     * 查询直播用户ID对应关注次数
     * @param companyId 公司ID
     * @param liveUserIdList 直播用户ID集合
     * @return key：直播用户ID，value：关注次数
     */
    Map<Long, Long> getUserSubscribeCount(Long companyId, List<Long> liveUserIdList);

    /**
     * 插入实体
     * @return 新增数量
     */
    Integer insertEntity(LiveSubscribeDto liveSubscribeDto);
}
