package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.live.LiveEndPageDto;
import cn.com.duiba.kjy.livecenter.api.param.live.LiveEndPageSearchParam;

import java.util.List;

/**
 * 直播结束页配置
 * @author ouyang
 * @date 2021/10/30
 */
@AdvancedFeignClient
public interface RemoteLiveEndPageService {


    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播结束页配置
     */
    LiveEndPageDto selectById(Long id);

    /**
     * 直播结束页列表
     * @param param 查询参数
     * @return 直播结束页列表
     */
    List<LiveEndPageDto> selectPageList(LiveEndPageSearchParam param);

    /**
     * 查询数据条数
     * @param param 查询参数
     * @return count
     */
    Long selectCount(LiveEndPageSearchParam param);

    /**
     * 新增/编辑
     * @param dto 直播结束页
     * @return true-成功 false-失败
     */
    boolean saveOrUpdate(LiveEndPageDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    boolean delete(Long id);

}
