package cn.com.duiba.kjy.livecenter.api.dto.task;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * @Author xujing
 * @Date 2020/11/10 4:11 下午
 */
@Data
public class TaskConfigDto implements Serializable {


    private static final long serialVersionUID = -8239382404505143644L;
    private Long id;

    /**
    * 任务标题
    */
    private String taskTitle;

    /**
    * 任务副标题
    */
    private String subTitle;

    /**
    * 任务logo
    */
    private String taskLogo;

    /**
    * 默认0 优先级越大越靠前
    */
    private Integer taskPriority;

    /**
    * 按钮文案
    */
    private String buttonText;

    /**
    * 任务完成后的按钮文案
    */
    private String successButtonText;

    /**
    * 直播间类型 0全部 1预告 2直播
    */
    private Integer liveType;

    /**
    * 任务类型 1通用任务 2直播间自定义任务
    */
    private Integer taskType;

    /**
    * 直播间定制任务时对应的直播间id
    */
    private Long liveId;

    /**
    * 任务能够用完成几次 0代表不限制
    */
    private Integer taskLimit;

    /**
    * 奖励类型 1 抽奖券
    */
    private Integer rewardType;

    /**
    * 奖励数量
    */
    private Integer rewardNumber;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
    * 额外字段 json类型
    */
    private String extraJson;

    /**
    * 任务完成类型 1 通用完成类型
    */
    private Integer taskCompleteType;

    /**
    * 任务展示前置条件 默认0 无条件 1用户配置抽奖福利
    */
    private Integer preCondition;

    /**
    * 视角 0 全部人可见 1仅代理人可见 2访客可见
    */
    private Integer taskPerspective;

    /**
     * 任务前端动作类型
     */
    private String webTypes;

    /**
     * 是否删除 默认0 已删除为1
     */
    private Integer deleted;

    /**
     * 抽奖码来源类型
     */
    private Integer sourceCode;

}