package cn.com.duiba.kjy.livecenter.api.enums.cardLibrary;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author xujing
 * @Date 2021/3/3 9:44 上午
 */
public enum CardCouponStatusEnum {

    NO_USE(0, "未发放"),
    ISSUE(1, "已发放"),;

    Integer code;
    String desc;

    CardCouponStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, CardCouponStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CardCouponStatusEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static CardCouponStatusEnum of(Integer code) {
        return ENUM_MAP.get(code);
    }
    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
