package cn.com.duiba.kjy.livecenter.api.enums.company;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chengsiyi
 * @date 2021/2/5 15:16
 */
public enum MpAuthStatusEnum {

    /**
     * 小程序授权状态
     */
    AUTHORIZE(0, "已授权"),

    UNAUTHORIZE(1, "取消授权");

    Integer authStatus;

    String desc;

    MpAuthStatusEnum(Integer authStatus, String desc) {
        this.authStatus = authStatus;
        this.desc = desc;
    }

    private static final Map<Integer, MpAuthStatusEnum> ENUM_MAP = new HashMap<>();

    static {
        for (MpAuthStatusEnum tmp : values()) {
            ENUM_MAP.put(tmp.getAuthStatus(), tmp);
        }
    }

    public static MpAuthStatusEnum getByType(Integer code) {
        return ENUM_MAP.get(code);
    }

    public Integer getAuthStatus() {
        return authStatus;
    }

    public String getDesc() {
        return desc;
    }
}
