package cn.com.duiba.kjy.livecenter.api.remoteservice.live.coupon;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.live.coupon.LiveCouponConfigDto;

import java.util.List;

/**
 * @Author xujing
 * @Date 2021/12/4 10:25 上午
 */
@AdvancedFeignClient
public interface RemoteLiveCouponConfigService {

    /**
     * 新增一条记录
     * @param record
     * @return
     */
    Long insert(LiveCouponConfigDto record);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    LiveCouponConfigDto selectById(Long id);

    /**
     * 根据id更新
     * @param record
     * @return
     */
    int updateById(LiveCouponConfigDto record);


    /**
     * 查询直播间优惠券配置列表
     * @param liveId
     * @return
     */
    List<LiveCouponConfigDto> listByLiveId(Long liveId);


}
