package cn.com.duiba.kjy.livecenter.api.param.user;

import lombok.Data;

import java.io.Serializable;

/**
 * @author chenhang
 * @date 2021/8/30 1:36 下午
 */
@Data
public class LiveUserParam implements Serializable {

    private static final long serialVersionUID = 6749840203962879280L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 业务方类型
     */
    private Integer bizType;

    /**
     * 业务方用户ID
     */
    private String bizUserId;

    /**
     * 用户的头像
     */
    private String avatar;

    /**
     * 用户的昵称
     */
    private String nickname;

    /**
     * 用户手机号
     */
    private String phone;

    /**
     * 小程序授权拿到的手机号
     */
    private String authPhone;

    /**
     * 小程序授权拿到的手机号的区号
     */
    private String authPhoneCountryCode;

    /**
     * 是否授权手机号，1-授权，0-未授权
     */
    private Integer authPhoneStatus;

    /**
     * 唯一ID，同一主体下唯一
     */
    private String unionId;

    /**
     * 用户性别，1=男性，2=女性，0=未知
     */
    private Integer gender;


}
