package cn.com.duiba.kjy.livecenter.api.enums.live;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chengsiyi
 * @date 2021/4/21 13:44
 */
public enum LiveInviteChannelEnum {
    /**
     * 用户邀请渠道
     */
    DEFAULT(0, "默认渠道"),
    DOUBLE_RED(1,"翻倍红包"),
    FISSION_ACHIEVE(2,"裂变活动-达标必得"),
    MULTI_PRIZE(3,"裂变活动-免费抽"),
    LUCKY_RED(4,"手气王"),
    FLIP_WORD(5,"集卡"),

    ;

    Integer inviteChannel;

    String desc;

    LiveInviteChannelEnum(Integer inviteChannel, String desc) {
        this.inviteChannel = inviteChannel;
        this.desc = desc;
    }

    public Integer getInviteChannel() {
        return inviteChannel;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, LiveInviteChannelEnum> ENUM_MAP = new HashMap<>();

    static {
        for (LiveInviteChannelEnum tmp : values()) {
            ENUM_MAP.put(tmp.getInviteChannel(), tmp);
        }
    }

    public static LiveInviteChannelEnum of(Integer code) {
        return ENUM_MAP.get(code);
    }
}
