package cn.com.duiba.kjy.livecenter.api.param.creditCard;

import cn.com.duiba.kjy.livecenter.api.enums.creditCard.ApplyCardStatusEnum;
import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @Author xujing
 * @Date 2021/7/12 4:00 下午
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class CreditCardApplyOrderSearchParam extends PageQuery {

    private static final long serialVersionUID = -2434050719069588998L;

    /**
     * 订单编号
     */
    private String orderNum;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 公司id
     */
    private Long companyId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 链接id
     */
    private Long cardConfId;

    /**
     * 进件开始时间
     */
    private Date applyStart;

    /**
     * 进件结束时间
     */
    private Date applyEnd;

    private Integer status = ApplyCardStatusEnum.APPLY_SUCCESS.getStatus();
}
