package cn.com.duiba.kjy.livecenter.api.param.invitation;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 直播代理人邀请关系
 * @author kjj mybatis generator
 * @date 2020-03-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveAgentInvitationSearchParam extends PageQuery {

    private static final long serialVersionUID = 15853608937853181L;


    /**
     * 直播公司ID
     */
    private Long companyId;

    /**
     * 直播公司下团队ID
     */
    private Long teamId;

    /**
     * 代理人ID
     */
    private Long agentId;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 直播访客userId集合
     */
    private List<Long> liveVisitorIds;

    /**
     * 是否到场：0-未到场，1-已到场
     */
    private Integer present;

    /**
     * 是否直接邀请: 0-间接邀请，1-直接邀请
     */
    private Integer directly;
}
