package cn.com.duiba.kjy.livecenter.api.dto.live;

import cn.com.duiba.kjy.livecenter.api.enums.creditCard.CardHolderTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 新人专享配置
 *
 * @Author xujing
 * @Date 2021/11/23 3:03 下午
 */
@Data
public class LiveNewcomersDto implements Serializable {

    private static final long serialVersionUID = -7108585687092303728L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 新人专享类型 0商品 1活动页
     */
    private Integer newsType;

    /**
     * 新人专享商品列表
     */
    private String goodsIds;

    /**
     * 新人专享限制 0不限制 1限制持卡已消费人群
     */
    private Integer newsLimit;

    /**
     * @see CardHolderTypeEnum card
     * 限制银行卡 json数组格式 枚举为持卡表的card
     */
    private String limitCard;

    /**
     * 活动头图
     */
    private String activityHeadImg;

    /**
     * 0开启 1关闭
     */
    private Integer activityStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}