package cn.com.duiba.kjy.livecenter.api.remoteservice.liveconf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.live.LiveExtDto;

import java.util.List;
import java.util.Map;

/**
 * 直播拓展信息配置rpc接口
 * @author 吴文哲
 * @date 2020-09-09 12:49
 **/
@AdvancedFeignClient
public interface RemoteLiveExtService {

    /**
     * 新增/修改直播间配置
     * 没有就新增 存在就修改
     * @param extDto 直播间配置对象
     * @return 保存结果
     */
    boolean saveLiveConfig(LiveExtDto extDto);

    /**
     * 批量新增/修改直播间配置
     * 没有就新增 存在就修改
     * @param extDtos 直播间配置对象
     * @return 保存结果
     */
    boolean batchSaveLiveConfig(List<LiveExtDto> extDtos);

    /**
     * 批量插入
     * @param list
     * @return
     */
    int batchInsert(List<LiveExtDto> list);

    /**
     * 根据直播间id 配置名 获取直播间配置
     * @param liveId 直播间id
     * @param confName 配置名称
     * @return 直播间配置
     */
    LiveExtDto getLiveExtByLiveIdAndConfName(Long liveId,Integer confName);

    /**
     * 根据直播间id 获取直播间配置列表
     * @param liveId 直播间id
     * @param confNameList 配置名称列表
     * @return 直播间配置列表
     */
    List<LiveExtDto> getLiveExtList(Long liveId,List<Integer> confNameList);


    /**
     * 获取直播间拓展配置键值对
     * @param liveId 直播间id
     * @param keys 配置id列表
     * @return 键值对
     */
    Map<Integer, String> getLiveConfigK2ValMap(Long liveId, List<Integer> keys);

}
