package cn.com.duiba.kjy.livecenter.api.dto.creditCard;

import cn.com.duiba.kjy.livecenter.api.enums.creditCard.CardHolderStatusEnum;
import cn.com.duiba.kjy.livecenter.api.enums.creditCard.CardHolderTypeEnum;
import cn.com.duiba.kjy.livecenter.api.enums.creditCard.ConsumeStatusEnum;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * @author chenhang
 * @date 2021/9/29 5:50 下午
 */
@Data
public class CardHolderInfoDto implements Serializable {
    private static final long serialVersionUID = -7036947682590316291L;

    /**
     * @see CardHolderTypeEnum
     * 持卡类型
     */
    @JSONField(name = "type")
    private Integer cardHolderType;

    /**
     * @see CardHolderStatusEnum
     * 持卡状态
     */
    @JSONField(name = "status")
    private Integer cardHolderStatus;

    /**
     * @see ConsumeStatusEnum
     * 消费状态
     */
    @JSONField(name = "consumeStatus")
    private Integer consumeStatus;

    /**
     * 查询时间
     */
    @JSONField(name = "time")
    private String queryTime;

}
