package cn.com.duiba.kjy.livecenter.api.dto.creditCard;

import cn.com.duiba.kjy.livecenter.api.enums.creditCard.ConsumeStatusEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author chenhang
 * @date 2022/1/13 11:30 上午
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LiveCardHolderDto implements Serializable {
    private static final long serialVersionUID = -2131137495736226866L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 公司id
     */
    private Long companyId;

    /**
     * 直播用户id
     */
    private Long liveUserId;

    /**
     * 持卡类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.creditCard.CardHolderTypeEnum
     */
    private Integer cardHolderType;

    /**
     * 持卡状态 1:已持卡 2:未持卡
     * @see cn.com.duiba.kjy.livecenter.api.enums.creditCard.CardHolderStatusEnum
     */
    private Integer cardHolderStatus;

    /**
     * 消费状态 1:已消费 0:未消费
     * @see ConsumeStatusEnum
     */
    private Integer consumeStatus = 0;

    /**
     * 手机号
     */
    private String phoneNum;

    /**
     * 扩展信息
     */
    private String extInfo = "";

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
