package cn.com.duiba.kjy.livecenter.api.enums.conf;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @Author xujing
 * @Date 2021/6/25 5:03 下午
 */
@Getter
public enum ResourceLocationJumpWayEnum {
    INTERNAL_JUMP(1,"内部跳转"),
    OUT_JUMP(2,"外部跳转"),
    ;


    private Integer type;

    private String desc;

    ResourceLocationJumpWayEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, ResourceLocationJumpWayEnum> ENUM_MAP = new HashMap<>();


    static {
        for (ResourceLocationJumpWayEnum applyCardTypeEnum : values()) {
            ENUM_MAP.put(applyCardTypeEnum.getType(), applyCardTypeEnum);
        }
    }

    public static ResourceLocationJumpWayEnum getByType(Integer key) {
        if (key == null) {
            return null;
        }
        return ENUM_MAP.get(key);
    }

    /**
     * 是否包含
     *
     * @param key
     * @return
     */
    public static boolean contains(Integer key) {
        if (null == key) {
            return false;
        }
        for (ResourceLocationJumpWayEnum enumVal : ResourceLocationJumpWayEnum.values()) {
            if (Objects.equals(enumVal.getType(), key)) {
                return true;
            }
        }
        return false;
    }
}
