package cn.com.duiba.kjy.livecenter.api.enums.home.page;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author zhuenhui
 * @date 2022/04/19 10:22
 * @description 小程序首页配置版本
 */
@Getter
@AllArgsConstructor
public enum HomePageVersionEnum {

    /**
     * 最老的版本
     */
    OLD(0, "老版本"),

    /**
     * 小程序首页搭建saas版
     * {@see href="http://cf.dui88.com/pages/viewpage.action?pageId=143040025"}
     */
    SAAS(1, "首页SaaS版本"),
    ;

    /**
     * 版本号
     */
    private final Integer version;

    /**
     * 描述
     */
    private final String desc;
}
