package cn.com.duiba.kjy.livecenter.api.param.conf;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import lombok.*;

import java.util.Date;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class LaunchConfigSearchParam extends PageQuery {
    private static final long serialVersionUID = -2434350419069588998L;

    private Long id;

    /**
     * 关联直播间id
     */
    private Long liveId;

    /**
     * @see cn.com.duiba.kjy.livecenter.api.enums.conf.LaunchLocationEnum
     * 1-直播间左侧
     */
    private Byte location;

    /**
     * 链接id
     */
    private Long linkId;

    /**
     * 链接背景图片
     */
    private String linkImage;

    /**
     * 上架标志 1-上架、0-下架
     */
    private Boolean onShelf;

    private Date gmtCreate;

    private Date gmtModified;

}
