package cn.com.duiba.kjy.livecenter.api.dto.smallshop.order;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: fss
 * @Date: 2021/9/7 15
 * @Description:
 */
@Data
public class OrderGoodsDetailDto implements Serializable {

    private static final long serialVersionUID = -3373737121385181081L;

    /**
     * 商品名称
     */
    @JSONField(name = "item_name")
    private String itemName;

    /**
     * 商品对应总价，total_price=price*quantity
     */
    @JSONField(name = "total_price")
    private String totalPrice;

    /**
     * 商品型号名称
     */
    @JSONField(name = "sku_title")
    private String skuTitle;

    /**
     * 商品型号编码
     */
    @JSONField(name = "sku_merchant_code")
    private String skuMerchantCode;

    /**
     * 分销分成比例
     */
    @JSONField(name = "fx_fee_rate")
    private String fxFeeRate;

    /**
     * 商品id
     */
    @JSONField(name = "item_id")
    private String itemId;

    /**
     * 商品编号
     */
    @JSONField(name = "merchant_code")
    private String merchantCode;

    /**
     * 价格
     */
    @JSONField(name = "price")
    private String price;

    /**
     * 商品数量
     */
    @JSONField(name = "quantity")
    private String quantity;

    /**
     * 商品URL
     */
    @JSONField(name = "url")
    private String url;

    /**
     * 商品图URL
     */
    @JSONField(name = "img")
    private String img;

    /**
     * 商品型号ID
     */
    @JSONField(name = "sku_id")
    private String skuId;

    /**
     * 商品发货状态：待发货 | 已发货 ｜（不在页面展示）
     */
    @JSONField(name = "deliver_status_desc")
    private String deliverStatusDesc;

    /**
     * 发货批次编号，代表一次发货（注：不是物流单号）
     */
    @JSONField(name = "deliver_id")
    private String deliverId;

    /**
     * 是否发货 1是0非
     */
    @JSONField(name = "is_delivered")
    private Integer isDelivered;

    /**
     * 商品是否可以发货 1是0非
     */
    @JSONField(name = "can_deliver")
    private Integer canDeliver;

    /**
     * 商品描述
     */
    @JSONField(name = "item_desc")
    private String itemDesc;

    /**
     * 子订单
     */
    @JSONField(name = "sub_order_id")
    private String subOrderId;
    /**
     * 品牌货源商品级供货价
     */
    @JSONField(name = "item_total_supplier_price")
    private String itemTotalSupplierPrice;

    /**
     * 是否是称重 1:是, 0:不是
     */
    @JSONField(name = "refund_weight_diff")
    private Integer refundWeightDiff;

    /**
     * 实际发货重量
     */
    @JSONField(name = "actual_weight")
    private String actualWeight;
    /**
     * 应发货重量
     */
    @JSONField(name = "display_weight")
    private String displayWeight;

    /**
     * 订单状态
     */
    @JSONField(name = "status")
    private String status;

    /**
     * 下单时间
     */
    @JSONField(name = "add_time")
    private String addTime;
    /**
     * 运费，和express_fee相同
     */
    @JSONField(name = "express_fee_num")
    private String expressFeeNum;

    /**
     * 买家手机号
     */
    @JSONField(name = "user_phone")
    private String userPhone;

    /**
     * 买家备注
     */
    @JSONField(name = "note")
    private String note;
    /**
     * 供货商ID 暂时没有用处，默认0
     */
    @JSONField(name = "g_seller_id")
    private String gSellerId;

    /**
     * 卖家手机号
     */
    @JSONField(name = "seller_phone")
    private String sellerPhone;

    /**
     * 订单状态说明
     */
    @JSONField(name = "status2")
    private String status2;
    /**
     * 分成推广佣金
     */
    @JSONField(name = "total_fee")
    private String totalFee;

    /**
     * 卖家微店名称
     */
    @JSONField(name = "seller_name")
    private String sellerName;

    /**
     * 订单类型描述
     */
    @JSONField(name = "order_type_des")
    private String orderTypeDes;


    /**
     * 是否投诉
     */
    @JSONField(name = "argue_flag")
    private Integer argueFlag;


    /**
     * 分销商店铺名称
     */
    @JSONField(name = "f_shop_name")
    private String fShopName;


    /**
     * 是否可以改价,0（表示不可改价）;1（表示可以改价）
     */
    @JSONField(name = "modify_price_enable")
    private String modifyPriceEnable;


    /**
     * 推广信息
     */
    @JSONField(name = "sk")
    private String sk;


    /**
     * 销商获取的分成金额
     */
    @JSONField(name = "fx_fee_value")
    private String fxFeeValue;

    /**
     * 快递单号
     */
    @JSONField(name = "express_no")
    private String expressNo;

    /**
     * 发货调用源, open:开放平台
     */
    @JSONField(name = "deliver_source")
    private String deliverSource;

    /**
     * [此字段已经废弃]
     */
    @JSONField(name = "buyer_identity_id")
    private String buyerIdentityId;


    /**
     * 发货时间
     */
    @JSONField(name = "send_time")
    private String sendTime;

    /**
     * 快递费用
     */
    @JSONField(name = "express_fee")
    private String expressFee;

    /**
     * 分销商ID,可以通过f_seller_id 判断是否是分销订单
     */
    @JSONField(name = "f_seller_id")
    private String fSellerId;

    /**
     * 担保交易过期时间
     */
    @JSONField(name = "confirm_expire")
    private String confirmExpire;


    /**
     * 订单类型编号，1为货到付款，2为直接交易，3为担保交易
     */
    @JSONField(name = "order_type")
    private String orderType;

    /**
     * 付款时间
     */
    @JSONField(name = "pay_time")
    private String payTime;

    /**
     * 订单状态详细描述
     */
    @JSONField(name = "status_desc")
    private String statusDesc;

    /**
     * 订单备注（卖家）
     */
    @JSONField(name = "express_note")
    private String expressNote;

    /**
     * 快递公司名称
     */
    @JSONField(name = "express")
    private String express;

    /**
     * 订单原价格，包括运费 （此字段用于记录订单被创建时的价格,包含运费，减去优惠后的价格）
     */
    @JSONField(name = "original_total_price")
    private String originalTotalPrice;

    /**
     * 订单总价 包含运费
     */
    @JSONField(name = "total")
    private String total;


    /**
     * 快递公司编号
     */
    @JSONField(name = "express_type")
    private String expressType;


    /**
     * 买家备注微信号
     */
    @JSONField(name = "weixin")
    private String weixin;


    /**
     * 只在待发货列表下生效，用于判断微团购订单是否已成团。其中 1已成团，0 未成团，-1 无意义新增此字段
     */
    @JSONField(name = "group_status")
    private Integer groupStatus;

    /**
     * 订单退款相关状态
     */
    @JSONField(name = "refund_status_ori")
    private String refundStatusOri;

    /**
     * 默认0
     */
    @JSONField(name = "is_over_sold")
    private String isOverSold;

    /**
     * 供货商ID,可以通过supplier_seller_id 判断是否是供货订单
     */
    @JSONField(name = "supplier_seller_id")
    private Integer supplierSellerId;

    /**
     * 订单状态
     */
    @JSONField(name = "status_ori")
    private String statusOri;

    /**
     * 退款信息
     */
    @JSONField(name = "refund_info")
    private RefundInfoDto refundInfo;

    /**
     * 跨境信息
     */
    @JSONField(name = "cross_item_info")
    private List<CrossItemDto> crossItemInfo;

    /**
     * 跨境信息
     */
    @JSONField(name = "cross_item_info")
    private List<CrossItemInfoDto> crossItemInfoDtoList;

}
