package cn.com.duiba.kjy.livecenter.api.enums.innerlog;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2021/5/26.
 */
@Getter
public enum InteractTypeEnum {

    SHARE(1, "share", "分享"),
    ATTENTION(2, "attention", "关注"),
    SUBSCRIBE(3, "subscribe", "预约"),
    ENTER_LIVE_FIRST_TIME(4,"enterLiveFirstTime","首次进入直播");


    private final Integer code;

    private final String  type;

    private final String  desc;

    InteractTypeEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static InteractTypeEnum getByCode(Integer code) {
        return Stream.of(InteractTypeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(SHARE);
    }

    public static InteractTypeEnum getByType(String type) {
        return Stream.of(InteractTypeEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(SHARE);
    }
}