package cn.com.duiba.kjy.livecenter.api.enums.live.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * @author xujing
 * @date 2020/12/04 11:33
 */
@Getter
@AllArgsConstructor
public enum CouponIssueUserEnum {
    ENTER(1, "进入直播间用户"),
    ATTENTION(2, "关注直播间用户"),
    NO_CONSUME(3, "未消费用户"),
    AGENT_DIRECT_INVITE(4, "客户经理直接邀请用户"),
    NO_AGENT_DIRECT_INVITE(5, "非客户经理直接邀请用户"),
    AGENT_DIRECT_INVITE_NO_CARD_NO_CONSUME(6, "客户经理直接邀请的未消费且非持卡用户"),
    NO_AGENT_DIRECT_INVITE_NO_CARD_NO_CONSUME(7, "非客户经理直接邀请的未消费且非持卡用户"),

    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    /**
     * 根据type获取枚举
     *
     * @param type markId
     * @return MessageMarkEnum
     */
    public static CouponIssueUserEnum getByType(Integer type) {
        return Arrays.stream(values()).filter(couponIssueLocationEnum -> Objects.equals(type, couponIssueLocationEnum.getType()))
                .findFirst()
                .orElse(null);
    }
}
