package cn.com.duiba.kjy.livecenter.api.enums.live.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author xujing
 * @date 2020/12/04 11:33
 */
@Getter
@AllArgsConstructor
public enum CouponStatusEnum {
    NOT_ENABLE(0, "未启用"),
    ENABLE(1, "已启用"),
    STOP(2, "暂停"),
    DELETED(3, "删除"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    /**
     * 根据type获取枚举
     *
     * @param type markId
     * @return MessageMarkEnum
     */
    public static CouponStatusEnum getByType(Integer type) {
        return Arrays.stream(values()).filter(couponIssueLocationEnum -> Objects.equals(type, couponIssueLocationEnum.getType()))
                .findFirst()
                .orElse(null);
    }
}
