package cn.com.duiba.kjy.livecenter.api.param.risk;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by hong
 * time 2021/11/3.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class LiveRiskListParam implements Serializable {

    private static final long serialVersionUID = 6476130453891913349L;

    /**
     * 主键
     * not null default = null
     */
    private Long id;

    /**
     * 直播id
     * not null default = null
     */
    private Long liveId;

    /**
     * 用户id
     * not null default = null
     */
    private Long userId;

    /**
     * 公司id
     * not null default = null
     */
    private Long companyId;

    /**
     * 开始时间
     * not null default = null
     */
    private Date startTime;

    /**
     * 结束时间
     * not null default = null
     */
    private Date endTime;

    /**
     * 风控类型
     * not null default = null
     * @see cn.com.duiba.kjy.livecenter.api.enums.risk.RiskTypeEnum
     */
    private Integer riskType;

    /**
     * 用户id集合
     */
    private List<Long> userIds;
}
