package cn.com.duiba.kjy.livecenter.api.enums.welfare;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chengsiyi
 * @date 2021/1/26 15:24
 */
public enum  LiveWelfareTypeEnum {

    /**
     * 福利类型
     */
    NORMAL(1,"普通福利"),
    PLATFORM_REDPACKET(2,"平台红包"),
    ELECTRONIC_GIFTS(3,"电子礼品")
    ;

    Integer welfareType;

    String desc;

    LiveWelfareTypeEnum(Integer welfareType, String desc) {
        this.welfareType = welfareType;
        this.desc = desc;
    }
    private static final Map<Integer, LiveWelfareTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(LiveWelfareTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getWelfareType(), tmp);
        }
    }

    public static LiveWelfareTypeEnum getByType(Integer code) {
        return ENUM_MAP.get(code);
    }

    public Integer getWelfareType() {
        return welfareType;
    }

    public String getDesc() {
        return desc;
    }
}
