package cn.com.duiba.kjy.livecenter.api.dto.risk;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by hong
 * time 2021/11/1.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class RiskConsumerDto implements Serializable {

    private static final long serialVersionUID = 1583448291761891491L;

    /**
     * 用户id
     */
    private String consumerId;
    /**
     * 设备id
     */
    private String deviceId;
    /**
     * 场景标识
     */
    private String sceneKey;
    /**
     * ip
     */
    private String ip;
    /**
     * ua
     */
    private String ua;
    /**
     * IOS、Android、H5，必传
     */
    private String         platform;
    /**
     * 请求时间：yyyy-mm-dd hh：mm：ss，必传
     */
    private Date date;
    /**
     * 系统来源(source)必传：目前支持 推啊广告(tuia-advert),趣闻(news),兑吧(duiba),兑吧直播(tuia-live)
     */
    private String  source;
    /**
     * 直播id
     */
    private Long  liveId;
}
