package cn.com.duiba.kjy.livecenter.api.remoteservice.community;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.bean.Page;
import cn.com.duiba.kjy.livecenter.api.dto.community.LaunchInfoDto;
import cn.com.duiba.kjy.livecenter.api.dto.community.LiveCommunityDrainageDto;
import cn.com.duiba.kjy.livecenter.api.dto.community.LiveCommunityLaunchDto;
import cn.com.duiba.kjy.livecenter.api.param.live.LiveCommunityLaunchParam;

import java.util.List;
import java.util.Map;

/**
 * Author: DSG
 * Date: 14:56 2022/1/5
 * Description: 社群聚合链路
 */
@AdvancedFeignClient
public interface RemoteLiveCommunityLaunchService {
    /**
     * 保存新的聚合链路
     * @param dto
     */
    void save(LiveCommunityLaunchDto dto);

    /**
     * 修改聚合链路
     * @param dto
     */
    void update(LiveCommunityLaunchDto dto);

    /**
     * 通过聚合id获取聚合信息
     * @param id
     * @return
     */
    LaunchInfoDto getLaunchInfoById(Long id);

    /**
     * 通过直播id获取聚合信息
     * @param liveId
     * @return
     */
    List<LaunchInfoDto> getLaunchInfoListByLiveId(Long liveId);

    /**
     * 翻页查询聚合链路
     * @param pageQuery
     * @return
     */
    Page<LiveCommunityLaunchDto> getList(LiveCommunityLaunchParam pageQuery);

    /**
     * 通过聚合id,获取绑定的引流id
     * @param ids
     * @return
     */
    Map<Long, List<LiveCommunityDrainageDto>> getLaunchDrainageMapByLaunchIds(List<Long> ids);

    /**
     * 通过绑定的引流id,获取聚合链路
     * @param ids
     * @return
     */
    Map<Long, List<LiveCommunityLaunchDto>> getLaunchMapByDrainageIds(List<Long> ids);

    /**
     * 删除聚合链路
     * @param id 聚合链路id
     */
    void removeById(Long id);

    /**
     * 删除绑定关系
     * @param drainageId 引流链接id
     */
    boolean removeLaunchDrainage(Long drainageId);


    /**
     * 获取聚合链接
     * @param id
     * @return
     */
    Map<Long, String> getLaunchUrl(List<Long> ids);
}
