package cn.com.duiba.kjy.livecenter.api.enums.live;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chengsiyi
 * @date 2020/11/19 14:56
 */
public enum  WelfareRainOptionTypeEnum {
    /**
     * 福利雨雨滴类型
     * 1-核销实物,2-核销红包，3-现金红包，4-产品资料，5-超值免单
     */
    OBJECT(1,"核销实物"),
    REDPACKET(2,"核销红包"),
    CASH_REDPACKET(3,"现金红包"),
    RESOURCE(4,"产品资料"),
    FREE_WELFARE(5,"超值免单"),

    ;

    Integer rainType;

    String desc;

    private static final Map<Integer, WelfareRainOptionTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(WelfareRainOptionTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getRainType(), tmp);
        }
    }

    public static WelfareRainOptionTypeEnum getByType(Integer rainType) {
        return ENUM_MAP.get(rainType);
    }

    WelfareRainOptionTypeEnum(Integer rainType, String desc) {
        this.rainType = rainType;
        this.desc = desc;
    }

    public Integer getRainType() {
        return rainType;
    }

    public String getDesc() {
        return desc;
    }
}
