package cn.com.duiba.kjy.livecenter.api.param;

import lombok.Data;

import java.io.Serializable;

/**
 * Created by dugq on 2020-03-31.
 *
 * 登陆授权同步用户信息
 */
@Data
public class SyncUserParam implements Serializable {
    private static final long serialVersionUID = 5959187331708301844L;
    /**
     * 业务方类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.BizTypeEnum
     */
    private Integer bizType;

    /**
     * 业务方用户ID
     */
    private String bizUserId;

    /**
     * 用户的头像
     */
    private String avatar;

    /**
     * 用户的昵称
     */
    private String nickname;

    /**
     * 用户手机号
     */
    private String phone;

    /**
     * 唯一ID，同一主体下唯一
     */
    private String unionId;

    /**
     * 用户性别，1=男性，2=女性，0=未知
     */
    private Integer gender;

    /**
     * 用户所在国家
     */
    private String country;

    /**
     * 用户所在省
     */
    private String province;

    /**
     * 用户所在市
     */
    private String city;

    /**
     * 备注
     */
    private String remark;

    /**
     * 微信用户的语言
     */
    private String lang;

    /**
     * 昵称拼音
     */
    private String nicknamePy;

    /**
     * 昵称拼音首字母
     */
    private String nicknamePyFast;

}
