/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.livecenter.api.utils;

import cn.com.duiba.kjy.livecenter.api.dto.third.ThirdMarkDto;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ThirdMarkUtils {
    private static final String SHARE_ENCRYPT = "87f2537ff7a3";

    private ThirdMarkUtils() {
    }

    public static String encodeMark(Long companyId, Long liveUserId) {
        ThirdMarkDto dto = new ThirdMarkDto();
        dto.setCompanyId(companyId);
        dto.setLiveUserId(liveUserId);
        return ThirdMarkUtils.encodeMark(dto);
    }

    public static String encodeMark(ThirdMarkDto dto) {
        if (Objects.isNull(dto)) {
            return null;
        }
        try {
            return BlowfishUtils.encryptBlowfish((String)JSON.toJSONString((Object)dto), (String)SHARE_ENCRYPT);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ThirdMarkDto decodeMark(String mark) {
        if (StringUtils.isBlank((CharSequence)mark) || "undefined".equals(mark) || StringUtils.equals((CharSequence)mark, (CharSequence)"null")) {
            return null;
        }
        try {
            String content = BlowfishUtils.decryptBlowfish((String)mark, (String)SHARE_ENCRYPT);
            JSONObject jsonObject = JSON.parseObject((String)content);
            ThirdMarkDto dto = (ThirdMarkDto)jsonObject.toJavaObject(ThirdMarkDto.class);
            if (dto == null) {
                return null;
            }
            return dto;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        ThirdMarkDto dto = new ThirdMarkDto();
        dto.setCompanyId(null);
        dto.setLiveUserId(null);
        String s = ThirdMarkUtils.encodeMark(dto);
        System.out.println(s);
        ThirdMarkDto dto1 = ThirdMarkUtils.decodeMark(s);
        System.out.println(dto1);
    }
}

