package cn.com.duiba.kjy.livecenter.api.enums;

import java.util.Objects;

/**
 * 分享加密类型
 * @author lizhi
 * @date 2020/4/12 11:40 AM
 */
public enum ShareTypeEnum {

    VISITOR_MP_SELLER_INVITATION(1,"访客端小程序-代理人分享直播"),
    VISITOR_MP_LIVE_ROOM_INVITATION(2,"访客端小程序-直播间分享直播"),
    VISITOR_MP_COMMUNITY_ACTIVITY_INVITATION(3,"访客端小程序-社群活动分享"),
    ;
    private Integer code;
    private String desc;

    ShareTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据类型值查询枚举
     * @param shareType 分享加密类型
     * @return 枚举
     */
    public static ShareTypeEnum getByCode(Integer shareType){
        for (ShareTypeEnum typeEnum : ShareTypeEnum.values()){
            if(Objects.equals(shareType,typeEnum.getCode())){
                return typeEnum;
            }
        }
        return null;
    }
}
