package cn.com.duiba.kjy.livecenter.api.utils;

import cn.com.duiba.kjy.livecenter.api.bean.share.AgentShareBean;
import cn.com.duiba.kjy.livecenter.api.bean.share.LiveRoomShareBean;
import cn.com.duiba.kjy.livecenter.api.bean.share.ShareBean;
import cn.com.duiba.kjy.livecenter.api.enums.ShareTypeEnum;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.util.Objects;

/**
 * 分享加解密工具类
 * @author lizhi
 * @date 2020/4/12 11:50 AM
 */
public class ShareUtils {

    /**
     * 分享签名加密盐
     */
    private static final String SHARE_ENCRYPT = "89f1657ff6a3";

    private ShareUtils() {}

    /**
     * 平衡加密
     * @param bean 分享参数
     * @return 加密串
     */
    public static <T extends ShareBean> String signShareBean(T bean){
        if (Objects.isNull(bean)){
            return null;
        }
        ShareTypeEnum shareTypeEnum = ShareTypeEnum.getByCode(bean.getShareType());
        if (shareTypeEnum == null) {
            return null;
        }
        try {
            return BlowfishUtils.encryptBlowfish(JSON.toJSONString(bean), SHARE_ENCRYPT);
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 解析分享加密串
     * @param sign 加密串
     * @param clazz 参数class
     * @return 分享参数
     */
    public static <T extends ShareBean> T decodeShareSign(String sign, Class<T> clazz){
        if (StringUtils.isBlank(sign) || "undefined".equals(sign) || StringUtils.equals(sign, "null")) {
            return null;
        }
        try {
            String content = BlowfishUtils.decryptBlowfish(sign, SHARE_ENCRYPT);
            JSONObject jsonObject = JSON.parseObject(content);
            T bean = jsonObject.toJavaObject(clazz);
            if (bean == null) {
                return null;
            }
            ShareTypeEnum shareTypeEnum = ShareTypeEnum.getByCode(bean.getShareType());
            if (shareTypeEnum == null) {
                return null;
            }
            if (!shareTypeEnum.getCode().equals(jsonObject.getInteger("shareType"))) {
                return null;
            }
            return bean;
        } catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
//        AgentShareBean bean = new AgentShareBean();
//        bean.setLiveId(1L);
//        bean.setAgentId(3L);
//        bean.setSharedUserId(5000L);
//        String content = signShareBean(bean);
//        System.out.println(content);
//        AgentShareBean shareBean = decodeShareSign(content, AgentShareBean.class);
//        System.out.println(shareBean);
//        LiveRoomShareBean roomShareBean1 = decodeShareSign(content, LiveRoomShareBean.class);
//        System.out.println(roomShareBean1);
//        shareBean = decodeShareSign(content, AgentShareBean.class);
//        System.out.println(shareBean);
//
//        LiveRoomShareBean roomShareBean = new LiveRoomShareBean();
//        roomShareBean.setLiveId(9999L);
//        roomShareBean.setSharedUserId(99999L);
//        roomShareBean.setLiveAgent(true);
//        roomShareBean.setAgentId(888L);
//        String c = signShareBean(roomShareBean);
//        System.out.println(c);
//        System.out.println(c.length());
        LiveRoomShareBean r = decodeShareSign("51jH3nXRvakEb4uKTxvfzcSGecKtQ1Mauayc758RcaefyTUxWMQhnfBoiSKF6Lcam5sdZ83Ki4ic392JR1fcTt25bKgC1JhYSeie7CdfwpvgL3qRmM", LiveRoomShareBean.class);
        AgentShareBean r1 = decodeShareSign("51jH3nXRvakEb4uKTxvfzcSGecKtQ1Mauayc758RcaefyTUxWMQhnfBoiSKF6Lcam5sdZ83Ki4ic392JR1fcTt25bKgC1JhYSeie7CdfwpvgL3qRmM", AgentShareBean.class);
        System.out.println(r);
        System.out.println(r1);
    }
}
