package cn.com.duiba.kjy.livecenter.api.utils;

import cn.com.duiba.kjy.livecenter.api.dto.third.ThirdMarkDto;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.util.Objects;

/**
 * 给第三方传输用户信息 加解密工具类
 * @author lizhi
 * @date 2020/4/12 11:50 AM
 */
public class ThirdMarkUtils {

    /**
     * 加密盐
     */
    private static final String SHARE_ENCRYPT = "87f2537ff7a3";

    private ThirdMarkUtils() {}

    /**
     * 平衡加密
     * @param companyId 直播公司ID
     * @param liveUserId 直播用户ID
     * @return 加密串
     */
    public static String encodeMark(Long companyId, Long liveUserId){
        ThirdMarkDto dto = new ThirdMarkDto();
        dto.setCompanyId(companyId);
        dto.setLiveUserId(liveUserId);
        return encodeMark(dto);
    }

    /**
     * 平衡加密
     * @param dto 给第三方传输用户信息
     * @return 加密串
     */
    public static String encodeMark(ThirdMarkDto dto){
        if (Objects.isNull(dto)){
            return null;
        }
        try {
            return BlowfishUtils.encryptBlowfish(JSON.toJSONString(dto), SHARE_ENCRYPT);
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 解析分享加密串
     * @param mark 加密串
     * @return 分享参数
     */
    public static ThirdMarkDto decodeMark(String mark){
        if (StringUtils.isBlank(mark) || "undefined".equals(mark) || StringUtils.equals(mark,"null")) {
            return null;
        }
        try {
            String content = BlowfishUtils.decryptBlowfish(mark, SHARE_ENCRYPT);
            JSONObject jsonObject = JSON.parseObject(content);
            ThirdMarkDto dto = jsonObject.toJavaObject(ThirdMarkDto.class);
            if (dto == null) {
                return null;
            }
            return dto;
        } catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        ThirdMarkDto dto = new ThirdMarkDto();
        dto.setCompanyId(null);
        dto.setLiveUserId(null);
        String s = encodeMark(dto);
        System.out.println(s);
        ThirdMarkDto dto1 = decodeMark(s);
        System.out.println(dto1);
    }
}
