/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.mall.api.util;

import cn.com.duiba.live.mall.api.response.OrderDetail;
import cn.com.duiba.live.mall.api.response.OrderPageResult;
import cn.com.duiba.live.mall.api.response.OrderRefundMoneyPageResult;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

public class BigDecimalUtils {
    public static Long getBigDecimalToLong(BigDecimal bigDecimal) {
        if (Objects.isNull(bigDecimal)) {
            return null;
        }
        return bigDecimal.multiply(new BigDecimal(100)).longValue();
    }

    public static BigDecimal getBigDecimalToBigDecimalCent(BigDecimal bigDecimal) {
        if (Objects.isNull(bigDecimal)) {
            return null;
        }
        return bigDecimal.multiply(new BigDecimal(100));
    }

    public static void transformOrderDetail(OrderDetail orderDetail) {
        orderDetail.setTotalPrice(BigDecimalUtils.getBigDecimalToBigDecimalCent(orderDetail.getTotalPrice()));
        orderDetail.setGoodsPrice(BigDecimalUtils.getBigDecimalToBigDecimalCent(orderDetail.getGoodsPrice()));
        orderDetail.setOriginOrderPrice(BigDecimalUtils.getBigDecimalToBigDecimalCent(orderDetail.getOriginOrderPrice()));
        orderDetail.setReducePrice(BigDecimalUtils.getBigDecimalToBigDecimalCent(orderDetail.getReducePrice()));
        orderDetail.setTransportFee(BigDecimalUtils.getBigDecimalToBigDecimalCent(orderDetail.getTransportFee()));
    }

    public static List<OrderPageResult> transformOrderList(List<OrderPageResult> list) {
        list.stream().forEach(orderPageResult -> {
            orderPageResult.setTotalPrice(BigDecimalUtils.getBigDecimalToBigDecimalCent(orderPageResult.getTotalPrice()));
            orderPageResult.setOriginOrderPrice(BigDecimalUtils.getBigDecimalToBigDecimalCent(orderPageResult.getOriginOrderPrice()));
            orderPageResult.setReducePrice(BigDecimalUtils.getBigDecimalToBigDecimalCent(orderPageResult.getReducePrice()));
            orderPageResult.setTransportFee(BigDecimalUtils.getBigDecimalToBigDecimalCent(orderPageResult.getTransportFee()));
            orderPageResult.getGoodsList().stream().forEach(orderItemDetail -> {
                orderItemDetail.setPrice(BigDecimalUtils.getBigDecimalToBigDecimalCent(orderItemDetail.getPrice()));
                orderItemDetail.setTotalPrice(BigDecimalUtils.getBigDecimalToBigDecimalCent(orderItemDetail.getTotalPrice()));
                orderItemDetail.setUnitPrice(BigDecimalUtils.getBigDecimalToBigDecimalCent(orderItemDetail.getUnitPrice()));
                orderItemDetail.getSkuList().stream().forEach(orderItemResult -> {
                    orderItemResult.setPrice(BigDecimalUtils.getBigDecimalToBigDecimalCent(orderItemResult.getPrice()));
                    orderItemResult.setTotalPrice(BigDecimalUtils.getBigDecimalToBigDecimalCent(orderItemResult.getTotalPrice()));
                });
            });
        });
        return list;
    }

    public static List<OrderRefundMoneyPageResult> transformRefundList(List<OrderRefundMoneyPageResult> list) {
        list.stream().forEach(orderRefundMoneyPageResult -> {
            orderRefundMoneyPageResult.setPrice(BigDecimalUtils.getBigDecimalToBigDecimalCent(orderRefundMoneyPageResult.getPrice()));
            orderRefundMoneyPageResult.setTotalPrice(BigDecimalUtils.getBigDecimalToBigDecimalCent(orderRefundMoneyPageResult.getTotalPrice()));
        });
        return list;
    }
}

