package cn.com.duiba.live.mall.api.dto.order;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/6/11
 * @description
 */
@Data
public class CreateOrderDto implements Serializable {

    /**
     * 商户ID
     */
    @NotNull(message = "商户ID不能为空")
    @Min(value = 1, message = "商户ID必须大于0")
    private Long merchantId;

    /**
     * 员工ID
     */
    @NotNull(message = "员工ID不能为空")
    @Min(value = 1, message = "员工ID必须大于0")
    private Long employeeId;

    /**
     * 订单创建人
     */
    @NotNull(message = "创建人ID不能为空")
    @Min(value = 1, message = "创建人ID必须大于0")
    private Long createUserId;

    /**
     * 开单人姓名
     */
    @NotBlank(message = "创建人姓名不能为空")
    private String createUserName;

    /**
     * 开单人账号
     */
    @NotBlank(message = "创建人账号不能为空")
    private String createAccount;

    /**
     * 客户ID
     */
    @NotNull(message = "客户ID不能为空")
    @Min(value = 1, message = "客户ID必须大于0")
    private Long customerId;

    /**
     * 客户UserId
     */
    @NotNull(message = "客户UserId不能为空")
    @Min(value = 1, message = "客户UserId必须大于0")
    private Long customerUserId;

    /**
     * 客户手机号
     */
    @NotBlank(message = "客户手机号不能为空")
    private String customerMobile;

    /**
     * 客户经办人名称
     */
    @NotBlank(message = "客户经办人名称不能为空")
    private String customerName;

    /**
     * 客户企业名称
     */
    private String customerEnterpriseName;

    /**
     * 订单确认时间
     */
    @NotNull(message = "订单确认时间不能为空")
    private Date confirmTime;

    /**
     * 商品列表
     */
    @Valid
    @Size(min = 1, message = "商品不能为空")
    private List<CreateOrderItemDto> goodsList;

    /**
     * 运输方式， 1-卖家送货/2-买家自提
     */
    private Byte transType;

    /**
     * 收货人名称
     */
    private String receiverName;

    /**
     * 收货人手机号码
     */
    private String receiverMobile;

    /**
     * 收货地址
     */
    private String receiverAddress;
}

