package cn.com.duiba.live.mall.api.dto.order;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 订单退款
 * @author youqian mybatis generator 
 * 2021-04-08
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OrderRefundDto implements Serializable {
    private static final long serialVersionUID = 1617869207063110L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 微信支付退款号
     * max length = 32
     * not null default = null
     */
    private String refundId;

    /**
     * 商户退款单号
     * max length = 32
     * not null default = null
     */
    private String outRefundNo;

    /**
     * 微信支付订单号
     * max length = 32
     * not null default = null
     */
    private String transactionId;

    /**
     * 商户订单号 : 商户系统内部订单号，要求32个字符内，只能是数字、大小写字母_-|*@ ，且在同一个商户号下唯一
     * max length = 32
     * not null default = null
     */
    private String outTradeNo;

    /**
     * 退款渠道	ORIGINAL：原路退款,BALANCE：退回到余额,OTHER_BALANCE：原账户异常退到其他余额账户,OTHER_BANKCARD：原银行卡异常退到其他银行卡
     * max length = 16
     * not null default = null
     */
    private String channel;

    /**
     * 退款入账账户 : 1）退回银行卡：{银行名称}{卡类型}{卡尾号} 2）退回支付用户零钱：支付用户零钱 3）退还商户：商户基本账户商户结算银行账户 4）退回支付用户零钱通：支付用户零钱通。
     * max length = 64
     * not null default = null
     */
    private String userReceivedAccount;

    /**
     * 退款成功时间
     * max length = 64
     * not null default = null
     */
    private String successTime;

    /**
     * 退款创建时间	
     * max length = 64
     * not null default = null
     */
    private String createTime;

    /**
     * 退款状态  SUCCESS：退款成功,CLOSED：退款关闭,PROCESSING：退款处理中,ABNORMAL：退款异常
     * max length = 32
     * not null default = null
     */
    private String status;

    /**
     * 资金账户	 : UNSETTLED : 未结算资金,AVAILABLE : 可用余额,UNAVAILABLE : 不可用余额,OPERATION : 运营户
     * max length = 32
     * not null default = null
     */
    private String fundsAccount;

    /**
     * 订单金额	
     * not null default = null
     */
    private Integer total;

    /**
     * 退款金额	
     * not null default = null
     */
    private Integer refund;

    /**
     * 用户支付金额	
     * not null default = null
     */
    private Integer payerTotal;

    /**
     * 用户退款金额	
     * not null default = null
     */
    private Integer payerRefund;

    /**
     * 应结退款金额	
     * not null default = null
     */
    private Integer settlementRefund;

    /**
     * 应结订单金额	
     * not null default = null
     */
    private Integer settlementTotal;

    /**
     * 优惠退款金额	
     * not null default = null
     */
    private Integer discountRefund;

    /**
     * 退款币种	
     * max length = 16
     * not null default = null
     */
    private String currency;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}