package cn.com.duiba.live.mall.api.dto.shopgoods;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 订单预约时间限制表
 * @author youqian mybatis generator 
 * 2021-03-26
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OrderBookingLimitDateDto implements Serializable {
    private static final long serialVersionUID = 16167532577453988L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 订单项ID
     * not null default = 0
     */
    private Long limitId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 货号ID
     * not null default = 0
     */
    private Long goodsId;

    /**
     * 货号规格ID
     * not null default = 0
     */
    private Long skuId;

    /**
     * 限制时间不能预约
     */
    private Date limitDate;

    /**
     * 是否删除，0-未删除，其他-已删除
     * not null default = 0
     */
    private Byte deleteFlag;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}